/*
 * Decompiled with CFR 0.152.
 */
package rs.ac.bg.etf.sab.tests;

import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import rs.ac.bg.etf.sab.operations.GeneralOperations;
import rs.ac.bg.etf.sab.operations.UsersOperations;
import rs.ac.bg.etf.sab.tests.TestHandler;

public class UsersOperationsTest {
    private TestHandler testHandler;
    private GeneralOperations generalOperations;
    private UsersOperations usersOperations;

    @Before
    public void setUp() {
        this.testHandler = TestHandler.getInstance();
        Assert.assertNotNull(this.testHandler);
        this.generalOperations = this.testHandler.getGeneralOperations();
        this.usersOperations = this.testHandler.getUsersOperations();
        Assert.assertNotNull(this.generalOperations);
        Assert.assertNotNull(this.usersOperations);
        this.generalOperations.eraseAll();
    }

    @After
    public void tearDown() {
        this.generalOperations.eraseAll();
    }

    @Test
    public void addUser_Valid() {
        Integer id = this.usersOperations.addUser("alice");
        Assert.assertNotNull(id);
        List<Integer> all = this.usersOperations.getAllUserIds();
        Assert.assertEquals(1L, all.size());
        Assert.assertTrue(all.contains(id));
    }

    @Test
    public void addUser_Duplicate() {
        Integer id1 = this.usersOperations.addUser("bob");
        Integer id2 = this.usersOperations.addUser("bob");
        Assert.assertNotNull(id1);
        Assert.assertNull(id2);
        List<Integer> all = this.usersOperations.getAllUserIds();
        Assert.assertEquals(1L, all.size());
        Assert.assertTrue(all.contains(id1));
    }

    @Test
    public void updateUser_Valid() {
        Integer id = this.usersOperations.addUser("carol");
        Integer upd = this.usersOperations.updateUser(id, "carol_new");
        Assert.assertEquals(id, upd);
        Assert.assertTrue(this.usersOperations.doesUserExist("carol_new"));
        Assert.assertFalse(this.usersOperations.doesUserExist("carol"));
    }

    @Test
    public void updateUser_Invalid() {
        Integer upd = this.usersOperations.updateUser(new Random().nextInt(), "nobody");
        Assert.assertNull(upd);
    }

    @Test
    public void removeUser_Valid() {
        Integer id = this.usersOperations.addUser("dave");
        Integer removed = this.usersOperations.removeUser(id);
        Assert.assertEquals(id, removed);
        Assert.assertFalse(this.usersOperations.doesUserExist("dave"));
        Assert.assertTrue(this.usersOperations.getAllUserIds().isEmpty());
    }

    @Test
    public void removeUser_Invalid() {
        Integer removed = this.usersOperations.removeUser(new Random().nextInt());
        Assert.assertNull(removed);
    }

    @Test
    public void doesUserExist_Check() {
        Assert.assertFalse(this.usersOperations.doesUserExist("eve"));
        Integer id = this.usersOperations.addUser("eve");
        Assert.assertTrue(this.usersOperations.doesUserExist("eve"));
        Assert.assertNotNull(id);
    }

    @Test
    public void getUserId_ValidAndInvalid() {
        Integer id = this.usersOperations.addUser("frank");
        Assert.assertEquals(id, this.usersOperations.getUserId("frank"));
        Assert.assertNull(this.usersOperations.getUserId("ghost"));
    }

    @Test
    public void getAllUserIds_Multiple() {
        Integer id1 = this.usersOperations.addUser("george");
        Integer id2 = this.usersOperations.addUser("helen");
        List<Integer> all = this.usersOperations.getAllUserIds();
        Assert.assertEquals(2L, all.size());
        Assert.assertTrue(all.contains(id1));
        Assert.assertTrue(all.contains(id2));
    }
}

