/*
 * Decompiled with CFR 0.152.
 */
package rs.ac.bg.etf.sab.tests;

import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import rs.ac.bg.etf.sab.tests.GenresOperationsTest;
import rs.ac.bg.etf.sab.tests.MoviesOperationsTest;
import rs.ac.bg.etf.sab.tests.PublicModuleTest;
import rs.ac.bg.etf.sab.tests.RatingsOperationsTest;
import rs.ac.bg.etf.sab.tests.TagsOperationsTest;
import rs.ac.bg.etf.sab.tests.UsersOperationsTest;
import rs.ac.bg.etf.sab.tests.WatchlistsOperationsTest;

public final class TestRunner {
    private static final int MAX_POINTS_ON_PUBLIC_TEST = 15;
    private static final Class[] UNIT_TEST_CLASSES = new Class[]{GenresOperationsTest.class, MoviesOperationsTest.class, RatingsOperationsTest.class, TagsOperationsTest.class, UsersOperationsTest.class, WatchlistsOperationsTest.class};
    private static final Class[] MODULE_TEST_CLASSES = new Class[]{PublicModuleTest.class};

    private static double runUnitTestsPublic() {
        double points = 0.0;
        JUnitCore jUnitCore = new JUnitCore();
        for (Class testClass : UNIT_TEST_CLASSES) {
            System.out.println("\n" + testClass.getName());
            Request request = Request.aClass(testClass);
            Result result = jUnitCore.run(request);
            int run = result.getRunCount();
            int failed = result.getFailureCount();
            int succeeded = run - failed;
            System.out.println("Successful:" + succeeded);
            System.out.println("All:" + run);
            if (run <= 0) continue;
            points += 2.0 * (double)succeeded / (double)run;
        }
        return points;
    }

    private static double runModuleTestsPublic() {
        double points = 0.0;
        JUnitCore jUnitCore = new JUnitCore();
        for (Class testClass : MODULE_TEST_CLASSES) {
            System.out.println("\n" + testClass.getName());
            Request request = Request.aClass(testClass);
            Result result = jUnitCore.run(request);
            int run = result.getRunCount();
            int failed = result.getFailureCount();
            int succeeded = run - failed;
            System.out.println("Successful:" + succeeded);
            System.out.println("All:" + run);
            if (run <= 0) continue;
            points += 3.0 * (double)succeeded / (double)run;
        }
        return points;
    }

    private static double runPublic() {
        double res = 0.0;
        res += TestRunner.runUnitTestsPublic();
        return res += TestRunner.runModuleTestsPublic();
    }

    public static void runTests() {
        double resultsPublic = TestRunner.runPublic();
        System.out.println("Points won on public tests is: " + resultsPublic + " out of 15");
    }
}

